/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.block.mushroom;

import com.ferreusveritas.dynamictrees.api.cell.Cell;
import com.ferreusveritas.dynamictrees.api.cell.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.block.branch.BranchBlock;
import com.ferreusveritas.dynamictrees.block.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import com.ferreusveritas.dynamictreesplus.block.mushroom.CapProperties;
import com.ferreusveritas.dynamictreesplus.block.mushroom.UpdatesSurroundNeighbors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DynamicCapBlock
extends HugeMushroomBlock
implements TreePart,
UpdatesSurroundNeighbors {
    public static final IntegerProperty DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)8);
    public CapProperties f_60439_ = CapProperties.NULL;

    public DynamicCapBlock(CapProperties capProperties, BlockBehaviour.Properties properties) {
        this(properties);
        this.setProperties(capProperties);
        capProperties.setDynamicCapState(this.m_49966_(), false);
    }

    public DynamicCapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISTANCE, (Comparable)Integer.valueOf(1))).m_61124_((Property)f_54127_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54128_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54129_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54130_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54131_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)f_54132_, (Comparable)Boolean.valueOf(true)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{DISTANCE, f_54131_, f_54132_, f_54127_, f_54128_, f_54129_, f_54130_});
    }

    public void setProperties(CapProperties properties) {
        this.f_60439_ = properties;
    }

    public CapProperties getProperties(BlockState blockState) {
        return this.f_60439_;
    }

    public Cell getHydrationCell(BlockGetter level, BlockPos pos, BlockState state, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    public int probabilityForBlock(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from) {
        return from.getFamily() == this.getFamily(state, level, pos) ? 2 : 0;
    }

    public int getRadiusForConnection(BlockState state, BlockGetter level, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return 0;
    }

    public int getRadius(BlockState state) {
        return 0;
    }

    public boolean shouldAnalyse(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public MapSignal analyse(BlockState state, LevelAccessor level, BlockPos pos, @Nullable Direction fromDir, MapSignal signal) {
        return signal;
    }

    public Family getFamily(BlockState state, BlockGetter level, BlockPos pos) {
        return this.f_60439_.getFamily();
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties(level.m_8055_(pos)).getFlammability();
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getProperties(level.m_8055_(pos)).getFireSpreadSpeed();
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction face) {
        return this.getFlammability(state, level, pos, face) > 0 || face == Direction.UP;
    }

    public int branchSupport(BlockState state, BlockGetter level, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return 0;
    }

    public TreePart.TreePartType getTreePartType() {
        return TreePart.TreePartType.OTHER;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return this.getProperties(state).getPrimitiveCapItemStack();
    }

    public static BlockState setDirectionValues(BlockState state, boolean[] directions) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)f_54132_, (Comparable)Boolean.valueOf(directions[0]))).m_61124_((Property)f_54131_, (Comparable)Boolean.valueOf(directions[1]))).m_61124_((Property)f_54127_, (Comparable)Boolean.valueOf(directions[2]))).m_61124_((Property)f_54129_, (Comparable)Boolean.valueOf(directions[3]))).m_61124_((Property)f_54130_, (Comparable)Boolean.valueOf(directions[4]))).m_61124_((Property)f_54128_, (Comparable)Boolean.valueOf(directions[5]));
    }

    public static boolean[] getDirectionValues(BlockState state) {
        if (state.m_60734_() instanceof HugeMushroomBlock) {
            return new boolean[]{(Boolean)state.m_61143_((Property)f_54132_), (Boolean)state.m_61143_((Property)f_54131_), (Boolean)state.m_61143_((Property)f_54127_), (Boolean)state.m_61143_((Property)f_54129_), (Boolean)state.m_61143_((Property)f_54130_), (Boolean)state.m_61143_((Property)f_54128_)};
        }
        return new boolean[6];
    }

    public GrowSignal growSignal(Level level, BlockPos pos, GrowSignal signal) {
        return signal;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
        if (random.m_188503_(50) == 0 && level.m_46859_(pos.m_7495_())) {
            Vec3 vec = this.f_60439_.sporeParticleSpeed(state, level, pos, random);
            level.m_7106_(this.f_60439_.sporeParticleType(state, level, pos, random), (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() - 0.1, (double)pos.m_123343_() + random.m_188500_(), vec.f_82479_, vec.f_82480_, vec.f_82481_);
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Level blockgetter = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54132_, (Comparable)Boolean.valueOf(!this.f_60439_.isPartOfCap(blockgetter.m_8055_(blockpos.m_7495_()))))).m_61124_((Property)f_54131_, (Comparable)Boolean.valueOf(!this.f_60439_.isPartOfCap(blockgetter.m_8055_(blockpos.m_7494_()))))).m_61124_((Property)f_54127_, (Comparable)Boolean.valueOf(!this.f_60439_.isPartOfCap(blockgetter.m_8055_(blockpos.m_122012_()))))).m_61124_((Property)f_54128_, (Comparable)Boolean.valueOf(!this.f_60439_.isPartOfCap(blockgetter.m_8055_(blockpos.m_122029_()))))).m_61124_((Property)f_54129_, (Comparable)Boolean.valueOf(!this.f_60439_.isPartOfCap(blockgetter.m_8055_(blockpos.m_122019_()))))).m_61124_((Property)f_54130_, (Comparable)Boolean.valueOf(!this.f_60439_.isPartOfCap(blockgetter.m_8055_(blockpos.m_122024_()))));
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return this.f_60439_.isPartOfCap(pFacingState) ? (BlockState)pState.m_61124_((Property)PipeBlock.f_55154_.get(pFacing), (Comparable)Boolean.valueOf(false)) : super.m_7417_(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean destroyed = super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
        this.updateNeighborsSurround(level, pos, DynamicCapBlock.class);
        return destroyed;
    }

    public void m_6861_(BlockState pState, Level level, BlockPos pos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        level.m_186460_(pos, pBlock, 0);
        super.m_6861_(pState, level, pos, pBlock, pFromPos, pIsMoving);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.m_8055_(pos).m_60734_() != this) {
            return;
        }
        int dist = (Integer)state.m_61143_((Property)DISTANCE);
        boolean supportFound = false;
        for (BlockPos offPos : BlockPos.m_121925_((BlockPos)pos, (int)1, (int)1, (int)1)) {
            BlockState offsetState;
            if (offPos == pos || (!(offsetState = level.m_8055_(offPos)).m_61138_((Property)DISTANCE) || (Integer)offsetState.m_61143_((Property)DISTANCE) != dist - 1) && (dist != 1 || offsetState.m_60734_() != this.f_60439_.getDynamicCapCenterBlock().orElse(null))) continue;
            supportFound = true;
            break;
        }
        if (!supportFound) {
            level.m_46961_(pos, true);
            this.updateNeighborsSurround((Level)level, pos, DynamicCapBlock.class);
            return;
        }
        super.m_213897_(state, level, pos, random);
    }
}

